-- ===========================================================================
--	Quo Configuration Options
-- ===========================================================================
local lastLocalTurnNumber = 0;

-- QUO CUSTOM OPTIONS
-- Handle variables stuff from the game options screen
-- local quo_option_border_speed = MapConfiguration.GetValue("QuoOptionBorderSpeed") ;

-- use this variable to track whether Gilgamesh is in game, and if so, what spot
local iCathy_D_Id = -1;

-- stores list of player ids who have met cathy
local kQuoPlayersMetCathy = {};

local g_iRollsPerPlayer = 3;


-- -- constants
-- local iQuoMinResourcesForMonopoly = 3;
-- local iQuoMinExposForWin = 12;


-- -- create the global resource table
-- arQuoMonopolyResources = {} ;

-- skip the first slots because we are not including anything but luxuries. these values tie to the position of luxes in the database.
-- this means mod is NOT compatible with any mods that delete resources or change order in the database.

-- arQuoMonopolyResources[10] =  "RESOURCE_CITRUS";
-- arQuoMonopolyResources[11] =  "RESOURCE_COCOA";
-- arQuoMonopolyResources[12] =  "RESOURCE_COFFEE";
-- arQuoMonopolyResources[13] =  "RESOURCE_COTTON";
-- arQuoMonopolyResources[14] =  "RESOURCE_DIAMONDS";
-- arQuoMonopolyResources[15] =  "RESOURCE_DYES";
-- arQuoMonopolyResources[16] =  "RESOURCE_FURS";
-- arQuoMonopolyResources[17] =  "RESOURCE_GYPSUM";
-- arQuoMonopolyResources[18] =  "RESOURCE_INCENSE";
-- arQuoMonopolyResources[19] =  "RESOURCE_IVORY";
-- arQuoMonopolyResources[20] =  "RESOURCE_JADE";
-- arQuoMonopolyResources[21] =  "RESOURCE_MARBLE";
-- arQuoMonopolyResources[22] =  "RESOURCE_MERCURY";
-- arQuoMonopolyResources[23] =  "RESOURCE_PEARLS";
-- arQuoMonopolyResources[24] =  "RESOURCE_SALT";
-- arQuoMonopolyResources[25] =  "RESOURCE_SILK";
-- arQuoMonopolyResources[26] =  "RESOURCE_SILVER";
-- arQuoMonopolyResources[27] =  "RESOURCE_SPICES";
-- arQuoMonopolyResources[28] =  "RESOURCE_SUGAR";
-- arQuoMonopolyResources[29] =  "RESOURCE_TEA";
-- arQuoMonopolyResources[30] =  "RESOURCE_TOBACCO";
-- arQuoMonopolyResources[31] =  "RESOURCE_TRUFFLES";
-- arQuoMonopolyResources[32] =  "RESOURCE_WHALES";
-- arQuoMonopolyResources[33] =  "RESOURCE_WINE";


-- Create the local resource tables that are updated every turn

-- ideally I would just create one array and have all the data lined up, but Lua is not a language in which I am very comfortable. as such,
-- there is one array for score and one for player and they don't talk to each other directly. We store the score
-- and the player based on the index of the resource as listed in arQuoMonopolyResources. This is a function that could
-- be vastly improved in a future revision.
-- arQuoMonopolyScore = {} ;
-- for i=0,34,1 
-- do 
	-- -- print(i)
	-- arQuoMonopolyScore[i] = 0 ;
-- end


-- arQuoMonopolyPlayer = {} ;





-- ===========================================================================
function fnQuo_Initialize()

	print ("Initialized Quo Custom Options.") ;
	print ("QuoOptionBorderSpeed:" .. tostring(quo_border_speed_option)  );
	

end

-- Changed in v3.10.1 to award 1 boost for one suzerain and 2 for 3
local function fnQuo_FreeCivicBoostOnEraChange( iPlayer )

	-- local sLeaderName = playerConfig:GetLeaderTypeName() ;

	--print ('ERA CHANGED  ') ;
	print ('ERA CHANGED REFRESH for ' .. tostring(iPlayer)) ;
	
	local pPlayer = Players[iPlayer];
	local playerConfig:table = PlayerConfigurations[iPlayer] ;
	local sLeaderName = playerConfig:GetLeaderTypeName() ;
	
	-- exit if this is turn 1 or earlier, it means the player is entering the first era 
	local currentTurn = Game.GetCurrentGameTurn();
	if (currentTurn < 2) then	
		return ;
	end
	
	if (sLeaderName == "LEADER_PERICLES") then
	 	local iNumFound = 0;
		local iNumAwards = 0;
		
		
		-- loop through minor civs and see who is in control. if it is Pericles, give him the boost
		local aMinorPlayers = PlayerManager.GetAliveMinors();
		for loop, pPlayerToCheck in ipairs(aMinorPlayers) do
			local iPlayerToCheck = pPlayerToCheck:GetID();
		
			local iSuze = pPlayerToCheck:GetInfluence():GetSuzerain() ;	
	
			print ('Current Suzeraine of: ' .. tostring (iPlayerToCheck) .. '  is:  ' .. tostring(iSuze));
			
			if (iSuze == iPlayer) then
				print ('Pericles is Suzerian! Initiating bonus boosts.')
			
				-- search for civics that can be boosted
				-- right now this fills an array with up to 4 civics to pick from, then ignores that array and just picks the first item
				-- leaving as in case a random element is ever introduced (too much effort to test at the moment hence hardcoded picks)
				local aPossibleTechBoosts = {};
				for row in GameInfo.Civics() do
					if (not pPlayer:GetCulture():HasCivic(row.Index)) then
						if (not pPlayer:GetCulture():HasBoostBeenTriggered(row.Index)) then
							iNumFound = iNumFound + 1;
							table.insert(aPossibleTechBoosts, row.Index);
							
							print ('Possible civic:' .. tostring(row.Index)) ;
							
							if iNumFound >= 4 then
								break;
							end
						end
					end
				end
				
				if (iNumFound > 0) then
					local iRoll = Game.GetRandNum(100, "Quo Free Civic Boost Event Roll");
					local iChosen = (iNumFound * iRoll) / 100 + 1;
					 
					 
					iNumAwards = iNumAwards + 1; 
					if (iNumAwards == 1) or (iNumAwards == 3) then
						-- for now just ignore the random roll and use the first tech
						pPlayer:GetCulture():TriggerBoost(aPossibleTechBoosts[1], 1); -- Trigger as if from goody hut
					end
								
				end
			end
			
		end
		
	end
	
end
Events.PlayerEraChanged.Add(fnQuo_FreeCivicBoostOnEraChange);
 

-- ===========================================================================
local function fnQuo_OnPlayerTurnActivated( player )

	print ('fnQuo_OnPlayerTurnActivated') ;
	local currentTurn = Game.GetCurrentGameTurn();
	local pPlayer = Players[player];
	
	local playerConfig:table = PlayerConfigurations[player] ;
	local sLeaderName = playerConfig:GetLeaderTypeName() ;
	
	
	if not (pPlayer:IsMajor()) then
		return
	end ; 
	
	if not (pPlayer:IsAlive()) then
		return
	end ;
	
	print ("fnQuo_OnPlayerTurnActivated: Player: " .. tostring(player) .. ", Turn " .. tostring(currentTurn) .. " LeaderName: " .. tostring(sLeaderName));


	-- Removed code below because it causes AI Gilga to freeze his civic research. Instead, he now gets a pop of Culture on turn 1 through a Modifier.
	
	-- on turn 1 give gilgamesh code of laws civic for free
	-- if (currentTurn == 1) then	
		-- if (sLeaderName == "LEADER_GILGAMESH") then
			-- -- local pCulture:table = pPlayer:GetCulture();
			-- -- pCulture:SetCivic(GameInfo.Civics["CIVIC_CODE_OF_LAWS"].Index, true);
			-- -- pCulture:SetCivicCompletedThisTurn(true);
			
			-- -- pCulture:UnlockGovernment(GameInfo.Governments["GOVERNMENT_CHIEFDOM"].Index);
			-- -- pCulture:SetCurrentGovernment(GameInfo.Governments["GOVERNMENT_CHIEFDOM"].Index);
		-- end
	-- end
	
	-- Save the ID of Cathy. We need to do this check every turn because the number gets lost when game is saved and reloaded.
	if (sLeaderName == "LEADER_CATHERINE_DE_MEDICI") then
		iCathy_D_Id = player ; 
	end
	
	
	-- local iHorses = GameInfo.Resources["RESOURCE_HORSES"].Index ; 
	-- print ("Horse Count: " .. tostring(pPlayer:GetResources():GetResourceAmount(iHorses) ) ) ;
	 
	-- introduce civs to Cathy if they have Writing and haven't met him
	-- changed in 3.07.1 to check to make sure player is a major civ
	
	local iTechToMeetCathy = GameInfo.Technologies["TECH_CASTLES"].Index ;
	
	if pPlayer:IsMajor() and (sLeaderName ~= "LEADER_CATHERINE_DE_MEDICI") then
		if (pPlayer:GetTechs():HasTech( iTechToMeetCathy )) then
			if (iCathy_D_Id ~= -1 ) and ((not pPlayer:GetDiplomacy():HasMet( iCathy_D_Id )) or (kQuoPlayersMetCathy[player] == nil)) then
			
				print ("Quo: Meeting Catherine D for Player: " .. tostring(sLeaderName)) ;
				
				-- Ideally Cathy would do her hello nice to meet you speech, but settling for this for now
				-- Players[ iCathy_D_Id ]:GetDiplomacy():SetVisibilityOn( player );
				
				-- Players[ player ]:GetDiplomacy():SetHasMet( iCathy_D_Id );
				
				
				-- Unveil the tile where the other civs capital is located
				local pCurPlayerVisibility = PlayersVisibility[ iCathy_D_Id ];
				
				if(pCurPlayerVisibility ~= nil) then
					
					local pCapitalCity = pPlayer:GetCities():GetCapitalCity();
					
					if pCapitalCity then
												
						local iCityPlotIndex = Map.GetPlot(pCapitalCity:GetX(), pCapitalCity:GetY()):GetIndex() ;
						pCurPlayerVisibility:ChangeVisibilityCount(iCityPlotIndex, 1);
						
						-- mark the fact that the player met Cathy in the Lua
						kQuoPlayersMetCathy[player] = 1 ;
					end
					
				end
				
				-- Players[ iCathy_D_Id ]:GetDiplomacy():SendKudoTo( player );
		
				Players[ player ]:GetDiplomacy():RecheckVisibilityOnAll();
								
			end
		end
	end

	if (player == 0) then
		if (currentTurn > lastLocalTurnNumber) then
			lastLocalTurnNumber = currentTurn;
		end
	end
	
	-- loop through players and see if options can be applied
	-- fnQuo_LoopTestApplyOptions() ;
		

	if (currentTurn < 10) then
		
		-- removed in favor of the MyOptions system, which is far more stable
		-- fnQuo_CreateOptionAdministration( player ) ;
	end 


	
	-- find any resources traded away in deals and populate a local table
	
	-- local kThisPlayerResourceTrades = {} ;
	
	-- the 34 below is the number of luxuries. this is not an ideal way to do this, but will do in a pinch
	-- for i=0,34,1 
	-- do 
		-- kThisPlayerResourceTrades[i] = 0 ;
	-- end
	

	--local sResourceName = arQuoMonopolyResources[iMonopolyIndex] ;
	--local iResourceID = GameInfo.Resources[sResourceName].Index ; 
	
	-- local kPlayers	:table = PlayerManager.GetAliveMajors();
	-- for _, pOtherPlayer in ipairs(kPlayers) do
		-- local otherID:number = pOtherPlayer:GetID();
		-- if  otherID ~= player then
	
			-- local pDeals		:table = DealManager.GetPlayerDeals(player, otherID);
		
			-- if pDeals ~= nil then
				-- for i,pDeal in ipairs(pDeals) do
					-- if pDeal:IsValid() then
						-- local pOutgoingDeal = pDeal:FindItemsByType(DealItemTypes.RESOURCES, DealItemSubTypes.NONE, player);
					
						-- if pOutgoingDeal ~= nil then
							-- for i,pDealItem in ipairs(pOutgoingDeal) do
								-- local duration		:number = pDealItem:GetDuration();
								
								-- if duration ~= 0 then
									-- local amount		:number = pDealItem:GetAmount();
									-- local resourceType	:number = pDealItem:GetValueType();
									
									-- -- if (resourceType == iResourceID) then
										-- --iAmount = iAmount + amount ;
										
									-- print ("ResourceType was: " .. tostring(resourceType) .. " Amount: " .. tostring(amount)) ;
									-- --end
									
									-- kThisPlayerResourceTrades[resourceType] =  kThisPlayerResourceTrades[resourceType] + amount ;
									
								-- end
							-- end
						-- end
						
						--UNNEEDED, because outgoing deals are already counted by Firaxis functions, which is weird, but whatever
						
						-- local pIncomingDeal = pDeal:FindItemsByType(DealItemTypes.RESOURCES, DealItemSubTypes.NONE, otherID);
						-- if pIncomingDeal ~= nil then
							-- for i,pDealItem in ipairs(pIncomingDeal) do
								-- local duration		:number = pDealItem:GetDuration();
								-- if duration ~= 0 then
									-- local amount		:number = pDealItem:GetAmount();
									-- local resourceType	:number = pDealItem:GetValueType();
									
									
									-- kThisPlayerResourceTrades[resourceType] =  kThisPlayerResourceTrades[resourceType] - amount ;
									
									-- -- local entryString:string = Locale.Lookup("LOC_HUD_REPORTS_ROW_DIPLOMATIC_DEALS") .. " (" .. Locale.Lookup(pPlayerConfig:GetPlayerName()) .. ")";
									-- -- AddResourceData(kResources, resourceType, entryString, "LOC_HUD_REPORTS_TRADE_IMPORTED", amount);				
								-- end
							-- end
						-- end
					-- end
				-- end
			-- end
		-- end
	-- end
	
		
	-- update monopolies
	-- this REALLY should be a loop, but my uncomfortableness with Lua is showing. 
	-- fnQuo_EvalMonopolyScore( player, 10, kThisPlayerResourceTrades[10] ) ;
	-- fnQuo_EvalMonopolyScore( player, 11, kThisPlayerResourceTrades[11] ) ;
	-- fnQuo_EvalMonopolyScore( player, 12, kThisPlayerResourceTrades[12] ) ;
	-- fnQuo_EvalMonopolyScore( player, 13, kThisPlayerResourceTrades[13] ) ;
	-- fnQuo_EvalMonopolyScore( player, 14, kThisPlayerResourceTrades[14] ) ;
	-- fnQuo_EvalMonopolyScore( player, 15, kThisPlayerResourceTrades[15] ) ;
	-- fnQuo_EvalMonopolyScore( player, 16, kThisPlayerResourceTrades[16] ) ;
	-- fnQuo_EvalMonopolyScore( player, 17, kThisPlayerResourceTrades[17] ) ;
	-- fnQuo_EvalMonopolyScore( player, 18, kThisPlayerResourceTrades[18] ) ;
	-- fnQuo_EvalMonopolyScore( player, 19, kThisPlayerResourceTrades[19] ) ;
	-- fnQuo_EvalMonopolyScore( player, 20, kThisPlayerResourceTrades[20] ) ;
	-- fnQuo_EvalMonopolyScore( player, 21, kThisPlayerResourceTrades[21] ) ;
	-- fnQuo_EvalMonopolyScore( player, 22, kThisPlayerResourceTrades[22] ) ;
	-- fnQuo_EvalMonopolyScore( player, 23, kThisPlayerResourceTrades[23] ) ;
	-- fnQuo_EvalMonopolyScore( player, 24, kThisPlayerResourceTrades[24] ) ;
	-- fnQuo_EvalMonopolyScore( player, 25, kThisPlayerResourceTrades[25] ) ;
	-- fnQuo_EvalMonopolyScore( player, 26, kThisPlayerResourceTrades[26] ) ;
	-- fnQuo_EvalMonopolyScore( player, 27, kThisPlayerResourceTrades[27] ) ;
	-- fnQuo_EvalMonopolyScore( player, 28, kThisPlayerResourceTrades[28] ) ;
	-- fnQuo_EvalMonopolyScore( player, 29, kThisPlayerResourceTrades[29] ) ;
	-- fnQuo_EvalMonopolyScore( player, 30, kThisPlayerResourceTrades[30] ) ;
	-- fnQuo_EvalMonopolyScore( player, 31, kThisPlayerResourceTrades[31] ) ;
	-- fnQuo_EvalMonopolyScore( player, 32, kThisPlayerResourceTrades[32] ) ;
	-- fnQuo_EvalMonopolyScore( player, 33, kThisPlayerResourceTrades[33] ) ;
	
	
	-- check to see if this player won a luxury victory
	-- fn_QuoCheckResourceVictoryWin( player ) ;
end

GameEvents.PlayerTurnStarted.Add(fnQuo_OnPlayerTurnActivated);





-- iMonopolyIndex is the index of the resource in arQuoMonopolyResources
-- iTradeOffset is the amount to increase or decrease the final amount based on stuff that has been traded away
function fnQuo_EvalMonopolyScore( iPlayerID, iMonopolyIndex, iTradeOffset ) 
	local pPlayer = Players[iPlayerID];
	
	local sResourceName = arQuoMonopolyResources[iMonopolyIndex] ;
	local iResourceID = GameInfo.Resources[sResourceName].Index ; 
	
	print ('EVALUATING ResourceID: ' .. tostring(iResourceID) .. "      sResourceName: " .. tostring(sResourceName) .. "     iMonopolyIndex: " .. tostring(iMonopolyIndex));
	

	-- count the number of resources
	local iAmount = pPlayer:GetResources():GetResourceAmount(iResourceID) + iTradeOffset;
	
	

	-- stuff to do if a previous owner exists
	local pOldOwner = Players[ arQuoMonopolyPlayer[iMonopolyIndex] ];
	local iOldPlayerID = arQuoMonopolyPlayer[iMonopolyIndex] ;
	
	if pOldOwner then
	
		-- if previous owner was killed, wipe out their score
		if not pOldOwner:IsAlive() then
			fnQuo_RemoveExpoInCapital(iOldPlayerID, iMonopolyIndex) ;
			arQuoMonopolyScore[iMonopolyIndex] = 0 ;
		end
		
		-- if the player whose turn it is is the previous owner, and their score has dropped too low, remove their access now
		if (iPlayerID == iOldPlayerID) and (iAmount < iQuoMinResourcesForMonopoly) then
			fnQuo_RemoveExpoInCapital(iPlayerID, iMonopolyIndex) ;
			arQuoMonopolyScore[iMonopolyIndex] = 0 ;
		end
	
	end
	

	print ("MONOPOLY CHECK. Player: " .. tostring(iPlayerID) .. " Resource: " .. sResourceName ..  "   Amount: " .. tostring(iAmount ) .. "   Score to Beat: " .. tostring(arQuoMonopolyScore[iMonopolyIndex])) ;
	
	-- do we have enough resource to surpass the min necessary for a monopoly?
	if (iAmount >= iQuoMinResourcesForMonopoly) then
	
		-- is the amount a tie? if so, no one wins and remove the resource from the old owner
		if (iAmount == arQuoMonopolyScore[iMonopolyIndex] ) and (iOldPlayerID) and (iPlayerID ~= iOldPlayerID) then
			fnQuo_RemoveExpoInCapital(iOldPlayerID, iMonopolyIndex) ;
			
			print ("Monopoly eliminated due to a tie! Player: " .. tostring(iPlayerID) .. " resource: " .. sResourceName);

		end
		
		-- is it more than whatever the current high score is?
		if (iAmount > arQuoMonopolyScore[iMonopolyIndex] ) then
			
			-- increase the monopoly score to match the new high score
			 arQuoMonopolyScore[iMonopolyIndex] = iAmount ;
			 
			-- if a new player got the monopoly, do stuff with the expo building. skip this if its the same player as before
			if (iPlayerID ~= iOldPlayerID) then
			
				print ("New monopoly! Player: " .. tostring(iPlayerID) .. " resource: " .. sResourceName .. " amount: " .. tostring(iAmount)) ;
				
				if iOldPlayerID then
					-- remove the building from the old owner, if there is one
					fnQuo_RemoveExpoInCapital(iOldPlayerID, iMonopolyIndex) ;
				end
			
				-- add the building to the new owner	
				fnQuo_PlaceExpoInCapital(iPlayerID, iMonopolyIndex) ;			
			end
				
		end
	end
	
end



function fnQuo_RemoveExpoInCapital( iPlayerID, iMonopolyIndex )
	local pPlayer = Players[iPlayerID];
	local sResourceName = arQuoMonopolyResources[iMonopolyIndex] ;

	-- register the change in the tracker table
	arQuoMonopolyPlayer[iMonopolyIndex] = nil ;

	print ("Removing expo: " .. sResourceName .. " from player: " .. tostring(iPlayerID) );
	
	local pCapitalCity ;
	
	if pPlayer then
		pCapitalCity = pPlayer:GetCities():GetCapitalCity();
	end
	
	iBuilding = GameInfo.Buildings["QUO_BUILDING_MONOPOLY_" .. sResourceName].Index ;

	
	if pCapitalCity then
		fnQuo_RemoveBuildingFromCityCenter(pCapitalCity, iBuilding) ;
	end
	
end



function fnQuo_PlaceExpoInCapital( iPlayerID, iMonopolyIndex )
	local pPlayer = Players[iPlayerID];
	local sResourceName = arQuoMonopolyResources[iMonopolyIndex] ;

	local pCapitalCity = pPlayer:GetCities():GetCapitalCity();
	
	
	iBuilding = GameInfo.Buildings["QUO_BUILDING_MONOPOLY_" .. sResourceName].Index ;

	print ("Adding expo: " .. sResourceName .. " to player: " .. tostring(iPlayerID) );
	
	-- test pop up message
	-- ReportingEvents.Send("EVENT_POPUP_REQUEST", { ForPlayer = iPlayerID, EventKey = 'QUO_MONOPOLY_POPUP' });
	
	if pCapitalCity then
		fnQuo_PlaceBuildingInCityCenter(pCapitalCity, iBuilding)
	end
				
	-- register the change in the tracker tables
	arQuoMonopolyPlayer[iMonopolyIndex] = iPlayerID ;
	
end



-- This is legacy code for the original options system. No longer used. Kept for posterity.
function fnQuo_CreateOptionAdministration( player )

	local pPlayer = Players[player];
	local pCapitalCity = pPlayer:GetCities():GetCapitalCity();
	
	
	if pCapitalCity then
		
		
		-- option administration
		
		-- exit function if Option Administration is already built		
		iBuilding = GameInfo.Buildings["QUO_BUILDING_OPTION_ADMINISTRATION_DUMMY"].Index ;
		
		if pCapitalCity:GetBuildings():HasBuilding(iBuilding) then
			return 
		end
		
		fnQuo_PlaceBuildingInCityCenter(pCapitalCity, iBuilding) ;
				
		print ("QUO_OPTION: Option Administration established in capital.") ;	
		
		
		-- border speed
		-- changed in 3.07.1 to apply to every player, and to skip over minor civs
		
		quo_option_border_speed = MapConfiguration.GetValue("QuoOptionBorderSpeed") ;
		print ("QuoOptionBorderSpeed was: " .. tostring(quo_option_border_speed)  );
		
		if (quo_option_border_speed > 0) and pPlayer:IsMajor() then
			iBuilding = GameInfo.Buildings["QUO_BUILDING_OPTION_BORDERS_DUMMY"].Index ;
			fnQuo_PlaceBuildingInCityCenter(pCapitalCity, iBuilding) ;
				
				
			print ("QUO_OPTION: Border speed bonus applied to Player " .. tostring(player) ) ;
				
			fnQuo_RemoveBuildingFromCityCenter(pCapitalCity, iBuilding) ;
		end
	end
	
end



function fnQuo_OnCityAddedToMap( playerID: number, cityID : number, cityX : number, cityY : number )
	
	print("CityAddedToMap - " .. tostring(playerID) .. ":" .. tostring(cityID) .. " " .. tostring(cityX) .. "x" .. tostring(cityY));

	local pGameReligion:table = Game.GetReligion();
	local pPlayer = Players[playerID];
	local pPlayerCities:table = pPlayer:GetCities();
	local pReligion = pPlayer:GetReligion();

	

end
-- GameEvents.CityBuilt.Add(fnQuo_OnCityAddedToMap );


-- Checks to see if the player won a resource victory.  
-- No longer used since there are mods out there that do this much better.
function fn_QuoCheckResourceVictoryWin( iPlayerID )

	local pPlayer = Players[ iPlayerID ];
	local pCapitalCity = pPlayer:GetCities():GetCapitalCity();

	if not pCapitalCity then
		return false ;
	end

	
	local iExpoCount = 0;
	
	-- An easier solution to this would be to just check on the array that contains a list of winning players. However, I am concerned
	-- about debugging possible de-syncs between the array and what players can see. So, instead, rely on the buildings present in the capital. 
	
	for k, v in pairs(arQuoMonopolyResources) do
		local sBuilding = "QUO_BUILDING_MONOPOLY_" .. tostring(v) ;
		local iBuilding = GameInfo.Buildings[sBuilding].Index ;
		
		print ("Resource Victory Check on: " .. sBuilding .. "   Building Index: " .. tostring(iBuilding)) ;
		
		if (pCapitalCity:GetBuildings():HasBuilding(iBuilding)) then
		
			print ("Expo building found!");
			iExpoCount = iExpoCount + 1;
		end
	end
	
	
	if iExpoCount >= iQuoMinExposForWin then
	
		-- do stuff that triggers victory 
		print('LUXURY VICTORY WON! Player: ' .. tostring(iPlayerID));
		
		
		local iBuilding = GameInfo.Buildings["QUO_BUILDING_RESOURCE_VICTORY_WIN"].Index ;
		
		fnQuo_PlaceBuildingInCityCenter(pCapitalCity, iBuilding) ;
		
		
		return true ;
	else
		return false ; 
	end
end



--function fnQuo_CheckActivateSpell()

--end
--GameEvents.ImprovementAddedToMap.Add( fnQuo_CheckActivateSpell );


-- Makes this player meet all major civs
function fnQuo_MakeMeetAllMajorCivs( playerID: number)

	print("Making player " .. tostring(playerID) .. "meet all major civs.") ;
	
	local pPlayer = Players[playerID];
	
	
	local aPlayers = PlayerManager.GetAliveMajors();
	for loop, pPlayerToMeet in ipairs(aPlayers) do
		local iPlayerToMeet = pPlayerToMeet:GetID();
		
		if (playerID ~= iPlayerToMeet) then
			Players[ playerID ]:GetDiplomacy():SetHasMet( iPlayerToMeet );
			Players[ playerID ]:GetDiplomacy():SetHasDelegationAt( iPlayerToMeet, true);
			Players[ iPlayerToMeet ]:GetDiplomacy():SetHasDelegationAt( playerID, true);
	
			Players[ playerID ]:GetDiplomacy():RecheckVisibilityOnAll();
			-- Players[ playerID ]:GetDiplomacy():SendKudoTo ( iPlayerToMeet ) ;
		end
	end

end


-- Add a unit to the map 
function fnQuo_AddUnitInCapital ( iPlayerID: number, sUnitType )

	local pPlayer = Players[iPlayerID];
	
	pPlayer:GetUnits():Create( sUnitType, iPlotX, iPlotY ) ;

	
end


-- ===========================================================================
-- Code borrowed from LeeS at CivFanatics forums for adding and removing buildings. Thanks Lee! 

function fnQuo_PlaceBuildingInCityCenter(pCity, iBuilding)
	local iCityPlotIndex = Map.GetPlot(pCity:GetX(), pCity:GetY()):GetIndex()

	if not pCity:GetBuildings():HasBuilding(iBuilding) then
		pCity:GetBuildQueue():CreateIncompleteBuilding(iBuilding, iCityPlotIndex, 100);
	end
end

function fnQuo_RemoveBuildingFromCityCenter(pCity, iBuilding)
	if pCity:GetBuildings():HasBuilding(iBuilding) then
		pCity:GetBuildings():RemoveBuilding(iBuilding);
	end
end


function GetArgumentDatas(sOrigin, tTable)
	print("============================================================================================")
	print("[" .. sOrigin .. "]: Dumping Event Hook Argument Data")
	print("............................................................................................")
	for k,v in pairs(tTable) do
		local sKeyType = type(k)
		local sValueType = type(v)
		print("[" .. sOrigin .. "]: Key is of type " .. sKeyType .. " = " .. tostring(k) .. ", Value is of type " .. sValueType .. " = " .. tostring(v))
	end
	print("............................................................................................")
	print("[" .. sOrigin .. "]: dump completed for this firing of the event")
	print("============================================================================================")
end



function fnQuoCityInitialized(iPlayer, iCityID)
	--OnCityInitialized(...)
	--OnCityInitialized(iPlayer, iCityID, iX, iY)
	print("Events.CityInitialized fired for function OnCityInitialized")
	--GetArgumentDatas("OnCityInitialized", {...})
	
	
	local iBuilding 
	local pPlayer = Players[iPlayer]
	
	
	if not pPlayer then
		print("[OnCityInitialized] pPlayer was nil")
	end
	
	local pCity = pPlayer:GetCities():FindID(iCityID)
	
	if not pCity then
		print("[OnCityInitialized] The founded city was nil")
		return
	end 
	
	iBuilding = GameInfo.Buildings["QUO_BUILDING_BEDROCK_ANCIENT"].Index 
	
	if pCity:GetBuildings():IsPillaged(iBuilding) then
		pCity:GetBuildings():SetPillaged(iBuilding, false)
	end
	
	
	iBuilding = GameInfo.Buildings["QUO_BUILDING_BEDROCK_MEDIEVAL"].Index 
	
	if pCity:GetBuildings():IsPillaged(iBuilding) then
		pCity:GetBuildings():SetPillaged(iBuilding, false)
	end
	
	
	iBuilding = GameInfo.Buildings["QUO_BUILDING_BEDROCK_RENAISSANCE"].Index 
	
	if pCity:GetBuildings():IsPillaged(iBuilding) then
		pCity:GetBuildings():SetPillaged(iBuilding, false)
	end
	
	
	print("[OnCityInitialized] Any pillaged Bedrocks have been repaired.")
	
end


function OnLoadScreenClose()
	--delay until after LoadScreenClose to avoid massive dumps in the log on reloading saved game
	Events.CityInitialized.Add(fnQuoCityInitialized)
end
Events.LoadScreenClose.Add(OnLoadScreenClose)




fnQuo_Initialize();

